/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.jspemul;

import com.ibm.hwmca.fw.servlet.jspemul.CompatJSPEmulator;
import com.ibm.hwmca.fw.servlet.jspemul.JSPEmulatorException;
import com.ibm.hwmca.fw.servlet.jspemul.ObjectPool;
import com.ibm.hwmca.fw.servlet.jspemul.PageContextEmul;
import com.ibm.hwmca.fw.servlet.jspemul.TLDManager;
import com.ibm.hwmca.fw.servlet.jspemul.TagInfoEmul;
import com.ibm.hwmca.fw.servlet.jspemul.TagPool;
import com.ibm.hwmca.fw.servlet.pmod.ModelContentHandler;
import com.ibm.hwmca.fw.servlet.pmod.ModelContentTCFException;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.taglibs.standard.lang.jstl.ELEvaluator;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.JSTLVariableResolver;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class JSPEmulator {
    private static final String TRACE_MASKT = "XJSPEMLT";
    private static final String TRACE_MASKF = "XJSPEMLF";
    private static final String TRACE_MASKD = "XJSPEMLD";
    private static final int BUFFER_SIZE = 8192;
    private static Map emulatorPoolMap = new HashMap();
    boolean performExtraChecking;
    boolean useOfficialJSPContainer;
    TLDManager tldManager;
    JSPContentHandler handler;
    PageContextEmul pageContext;
    String[] prefixes;
    TagLibraryInfo[] tagLibraries;
    ELEvaluator elEvaluator;
    TagPool tagPool;
    List tagStateStack;
    ObjectPool tagStatePool;
    Object[] valueArray = new Object[1];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Object;

    public static synchronized JSPEmulator getEmulatorInstance(ServletContext servletContext) {
        List emulatorPool = (List)emulatorPoolMap.get(servletContext.getServletContextName());
        while (emulatorPool != null && !emulatorPool.isEmpty()) {
            SoftReference emulatorRef = (SoftReference)emulatorPool.remove(emulatorPool.size() - 1);
            JSPEmulator emulator = (JSPEmulator)emulatorRef.get();
            if (emulator == null) continue;
            Trace.trace(TRACE_MASKT, "Returning JSP emulator " + emulator + " from pool for context \"" + servletContext.getServletContextName() + "\".  Current pool size is " + emulatorPool.size());
            return emulator;
        }
        Trace.trace(TRACE_MASKT, "Returning new JSP emulator instance.");
        return new JSPEmulator();
    }

    public static synchronized void returnEmulatorInstance(JSPEmulator emulator, ServletContext servletContext) {
        ArrayList<SoftReference<JSPEmulator>> emulatorPool = (ArrayList<SoftReference<JSPEmulator>>)emulatorPoolMap.get(servletContext.getServletContextName());
        if (emulatorPool == null) {
            emulatorPool = new ArrayList<SoftReference<JSPEmulator>>();
            emulatorPoolMap.put(servletContext.getServletContextName(), emulatorPool);
        }
        emulatorPool.add(new SoftReference<JSPEmulator>(emulator));
        Trace.trace(TRACE_MASKT, "Putting JSP emulator " + emulator + " into pool for context \"" + servletContext.getServletContextName() + "\".  New pool size is " + emulatorPool.size());
    }

    public JSPEmulator() {
        this.performExtraChecking = ServletRuntime.getRuntime().getServletOptions().getBoolean("jspemul.extra.checking", false);
        Trace.trace(TRACE_MASKT, "performExtraChecking is " + this.performExtraChecking);
        this.useOfficialJSPContainer = ServletRuntime.getRuntime().getServletOptions().getBoolean("jspemul.use.official.container", false);
    }

    public void processMarkup(Servlet servlet, ServletContext servletContext, PanelModel panelModel, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.useOfficialJSPContainer) {
            new CompatJSPEmulator(servletContext).processMarkup(panelModel, req, resp);
            return;
        }
        if (this.handler == null) {
            this.handler = new JSPContentHandler();
            this.elEvaluator = new ELEvaluator((VariableResolver)new JSTLVariableResolver());
            this.pageContext = new PageContextEmul();
            this.tagPool = new TagPool();
            this.tagStateStack = new ArrayList();
            this.tagStatePool = new ObjectPool();
            try {
                this.tldManager = TLDManager.getTLDManager(servletContext);
            }
            catch (JspException e) {
                throw new ServletException("Error parsing TLD files for context \"" + servletContext.getServletContextName() + "\"", (Throwable)e);
            }
        }
        this.pageContext.initialize(servlet, (ServletRequest)req, (ServletResponse)resp, null, true, 8192, true);
        try {
            Trace.trace(TRACE_MASKT, "Calling PanelModel.serialize()");
            panelModel.serialize(this.handler);
            Trace.trace(TRACE_MASKT, "Back from PanelModel.serialize()");
        }
        catch (PanelModelException e) {
            Trace.trace(TRACE_MASKT, "Got PanelModelException from serialize()");
            Trace.trace(TRACE_MASKT, e);
            throw new ServletException("Error processing panel model as JSP", (Throwable)e);
        }
        finally {
            this.pageContext.release();
            this.recycleEmulator();
        }
    }

    private void recycleEmulator() {
        this.prefixes = null;
        this.tagLibraries = null;
        this.valueArray[0] = null;
    }

    protected void finalize() {
        if (this.tagPool != null) {
            this.tagPool.releaseAllHandlers();
        }
    }

    private boolean isCustomTagPrefix(String tagPrefix) {
        return tagPrefix.length() != 0;
    }

    private int processCustomTagStart(String tagPrefix, String tagName, Properties attributes, boolean bodyIsEmpty) throws JSPEmulatorException, ModelContentTCFException {
        int startResponse;
        Tag handler;
        TagLibraryInfo taglibInfo = this.getTagLibForPrefix(tagPrefix);
        if (taglibInfo == null) {
            throw new JSPEmulatorException("Unknown prefix \"" + tagPrefix + "\" encountered on <" + tagPrefix + ':' + tagName + "> tag.");
        }
        TagInfoEmul tagInfo = (TagInfoEmul)taglibInfo.getTag(tagName);
        if (tagInfo == null) {
            throw new JSPEmulatorException("Unknown tag \"" + tagName + "\" encountered on <" + tagPrefix + ':' + tagName + "> tag.");
        }
        TagAttributeInfo[] attributeInfo = tagInfo.getAttributes();
        if (this.performExtraChecking) {
            TagExtraInfo extraInfo = tagInfo.getTagExtraInfo();
            Hashtable<String, Object> tagDataAttributes = null;
            if (extraInfo != null) {
                tagDataAttributes = new Hashtable<String, Object>();
            }
            Enumeration<Object> keyEnum = attributes.keys();
            while (keyEnum.hasMoreElements()) {
                boolean usingExpression;
                int i;
                String attributeName = (String)keyEnum.nextElement();
                String attributeValue = attributes.getProperty(attributeName);
                for (i = 0; i < attributeInfo.length && !attributeInfo[i].getName().equals(attributeName); ++i) {
                }
                if (i > attributeInfo.length) {
                    throw new JSPEmulatorException("Unknown attribute \"" + attributeName + "\" specified on <" + tagPrefix + ':' + tagName + "> tag.");
                }
                boolean bl = usingExpression = attributeValue.indexOf("${") != -1;
                if (tagDataAttributes == null) continue;
                tagDataAttributes.put(attributeName, usingExpression ? TagData.REQUEST_TIME_VALUE : attributeValue);
            }
            for (int i = 0; i < attributeInfo.length; ++i) {
                if (!attributeInfo[i].isRequired() || attributes.containsKey(attributeInfo[i].getName())) continue;
                throw new JSPEmulatorException("Required attribute \"" + attributeInfo[i].getName() + "\" is missing from <" + tagPrefix + ':' + tagName + "> tag.");
            }
            if (tagInfo.getBodyContent() == "EMPTY" && !bodyIsEmpty) {
                throw new JSPEmulatorException("Body must be empty for <" + tagPrefix + ':' + tagName + "> tag.");
            }
            if (extraInfo != null) {
                try {
                    boolean isValid = extraInfo.isValid(new TagData(tagDataAttributes));
                    if (!isValid) {
                        throw new JSPEmulatorException("TagExtraInfo implementation rejected attributes on <" + tagPrefix + ':' + tagName + "> tag.");
                    }
                }
                catch (Throwable e) {
                    throw new JSPEmulatorException("TagExtraInfo implementation raised exception on <" + tagPrefix + ':' + tagName + "> tag.", e);
                }
            }
        }
        String[] attributeNames = new String[attributes.size()];
        Enumeration<Object> keyEnum = attributes.keys();
        int i = 0;
        while (keyEnum.hasMoreElements()) {
            attributeNames[i] = (String)keyEnum.nextElement();
            ++i;
        }
        if (tagPrefix.equals("wcl")) {
            try {
                handler = (Tag)Class.forName(tagInfo.getTagClassName()).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JSPEmulatorException("Tag handler class not found", e);
            }
            catch (InstantiationException e) {
                throw new JSPEmulatorException("Error instantiating tag handler class", e);
            }
            catch (IllegalAccessException e) {
                throw new JSPEmulatorException("Tag handler class not public", e);
            }
        } else {
            handler = this.tagPool.getHandlerFromPool(tagInfo.getTagClassName(), attributeNames);
        }
        try {
            handler.setPageContext((PageContext)this.pageContext);
        }
        catch (Throwable e) {
            throw new ModelContentTCFException("Exception calling Tag.setPageContext()", e);
        }
        Tag parent = null;
        if (!this.tagStateStack.isEmpty()) {
            parent = ((TagState)this.tagStateStack.get(this.tagStateStack.size() - 1)).getTag();
        }
        try {
            handler.setParent(parent);
        }
        catch (Throwable e) {
            throw new ModelContentTCFException("Exception calling Tag.setParent()", e);
        }
        this.setHandlerAttributes(tagPrefix, tagInfo, handler, attributes);
        TagState tagState = (TagState)this.tagStatePool.getFromPool();
        if (tagState == null) {
            tagState = new TagState();
        }
        tagState.setTagInfo(tagInfo);
        tagState.setTag(handler);
        tagState.setAttributeNames(attributeNames);
        tagState.setBodyEmpty(bodyIsEmpty);
        tagState.setHandlerReusable(!tagPrefix.equals("wcl"));
        this.tagStateStack.add(tagState);
        Trace.trace(TRACE_MASKD, "Calling doStartTag() for tag \"" + tagInfo.getTagName() + "\" in " + tagInfo.getTagClassName());
        try {
            startResponse = handler.doStartTag();
        }
        catch (Throwable e) {
            return this.processExceptionInStartElement(tagState, handler, e);
        }
        int response = 0;
        if (handler instanceof TryCatchFinally) {
            response = 2;
        }
        if (startResponse == 0) {
            tagState.setSkippingBody(true);
            return response | 1;
        }
        response |= 0;
        if (startResponse == 1) {
            return response;
        }
        if (startResponse != 2) {
            throw new JSPEmulatorException("Unknown response value " + startResponse + " received from doStartTag() call on <" + tagPrefix + ':' + tagName + "> tag.");
        }
        if (!(handler instanceof BodyTag)) {
            throw new JSPEmulatorException("The <" + tagPrefix + ':' + tagName + "> tag's doStartTag() method returned BodyTag.EVAL_BODY_BUFFERED, but the handler doesn't implement BodyTag");
        }
        if (bodyIsEmpty) {
            return response;
        }
        Trace.trace(TRACE_MASKD, "Pushing body content for tag \"" + tagInfo.getTagName() + '\"');
        BodyContent bodyContent = this.pageContext.pushBody();
        tagState.setOutputStreamIsPushed(true);
        BodyTag bodyHandler = (BodyTag)handler;
        try {
            bodyHandler.setBodyContent(bodyContent);
            bodyHandler.doInitBody();
        }
        catch (Throwable e) {
            return this.processExceptionInStartElement(tagState, handler, e);
        }
        return response;
    }

    private int processExceptionInStartElement(TagState tagState, Tag handler, Throwable e) throws ModelContentTCFException {
        if (!(handler instanceof TryCatchFinally)) {
            throw new ModelContentTCFException("Exception during start element", e);
        }
        try {
            ((TryCatchFinally)handler).doCatch(e);
        }
        catch (Throwable ee) {
            try {
                ((TryCatchFinally)handler).doFinally();
                throw new ModelContentTCFException("Exception after calling doCatch()/doFinally()", ee);
            }
            catch (Throwable eee) {
                throw new ModelContentTCFException("Exception from doFinally()", eee);
            }
        }
        tagState.setExceptionDuringStartProcessing(true);
        return 1;
    }

    private Object convertAttributeString(String valueString, Class targetType, Class propertyEditor) throws JSPEmulatorException {
        try {
            if (propertyEditor != null) {
                PropertyEditor editor = (PropertyEditor)propertyEditor.newInstance();
                editor.setAsText(valueString);
                return editor.getValue();
            }
            if (targetType == (class$java$lang$String == null ? (class$java$lang$String = JSPEmulator.class$("java.lang.String")) : class$java$lang$String)) {
                return valueString;
            }
            if (targetType == Integer.TYPE || targetType == (class$java$lang$Integer == null ? (class$java$lang$Integer = JSPEmulator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return valueString.length() != 0 ? Integer.valueOf(valueString) : new Integer(0);
            }
            if (targetType == Boolean.TYPE || targetType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSPEmulator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return Boolean.valueOf(valueString);
            }
            if (targetType == Byte.TYPE || targetType == (class$java$lang$Byte == null ? (class$java$lang$Byte = JSPEmulator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return valueString.length() != 0 ? Byte.valueOf(valueString) : new Byte(0);
            }
            if (targetType == Character.TYPE || targetType == (class$java$lang$Character == null ? (class$java$lang$Character = JSPEmulator.class$("java.lang.Character")) : class$java$lang$Character)) {
                return valueString.length() != 0 ? new Character(valueString.charAt(0)) : new Character('\u0000');
            }
            if (targetType == Double.TYPE || targetType == (class$java$lang$Double == null ? (class$java$lang$Double = JSPEmulator.class$("java.lang.Double")) : class$java$lang$Double)) {
                return valueString.length() != 0 ? Double.valueOf(valueString) : new Double(0.0);
            }
            if (targetType == Float.TYPE || targetType == (class$java$lang$Float == null ? (class$java$lang$Float = JSPEmulator.class$("java.lang.Float")) : class$java$lang$Float)) {
                return valueString.length() != 0 ? Float.valueOf(valueString) : new Float(0.0f);
            }
            if (targetType == Long.TYPE || targetType == (class$java$lang$Long == null ? (class$java$lang$Long = JSPEmulator.class$("java.lang.Long")) : class$java$lang$Long)) {
                return valueString.length() != 0 ? Long.valueOf(valueString) : new Long(0L);
            }
            if (targetType == Short.TYPE || targetType == (class$java$lang$Short == null ? (class$java$lang$Short = JSPEmulator.class$("java.lang.Short")) : class$java$lang$Short)) {
                return valueString.length() != 0 ? Short.valueOf(valueString) : new Short(0);
            }
            if (targetType == (class$java$lang$Object == null ? (class$java$lang$Object = JSPEmulator.class$("java.lang.Object")) : class$java$lang$Object)) {
                return valueString;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(targetType);
            if (editor != null) {
                editor.setAsText(valueString);
                return editor.getValue();
            }
            throw new JSPEmulatorException("Unable to convert attribute string \"" + valueString + "\" to instance of class " + targetType.getName());
        }
        catch (Exception e) {
            throw new JSPEmulatorException("Exception converting attribute string \"" + valueString + "\"to instance of class " + targetType.getName(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setHandlerAttributes(String tagPrefix, TagInfoEmul tagInfo, Tag handler, Properties attributes) throws JSPEmulatorException, ModelContentTCFException {
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            boolean suppressEvaluation;
            Map.Entry<Object, Object> entry = iterator.next();
            String attribute = (String)entry.getKey();
            String valueString = (String)entry.getValue();
            TagInfoEmul.AttributeInfo attrInfo = tagInfo.getAttributeInfo(attribute);
            boolean bl = suppressEvaluation = tagPrefix.equals("c") || tagPrefix.equals("fmt");
            if (suppressEvaluation || valueString.indexOf("${") == -1) {
                value = this.convertAttributeString(valueString, attrInfo.propertyType, attrInfo.propertyEditorClass);
                Trace.trace(TRACE_MASKD, "Target type of attribute \"" + attribute + "\" is " + attrInfo.propertyType + ". Converted value is of type " + value.getClass().getName() + ". Value is " + value);
            } else {
                Trace.trace(TRACE_MASKF, "Evaluating attribute expression: " + valueString);
                try {
                    value = this.elEvaluator.evaluate(valueString, (Object)this.pageContext, attrInfo.propertyType, null, "");
                    Trace.trace(TRACE_MASKD, "Target type of expression attribute \"" + attribute + "\" is " + attrInfo.propertyType + ". Expression is \"" + valueString + "\". Result is of type " + (value == null ? "<null>" : value.getClass().getName()) + ". Value is " + value);
                }
                catch (ELException e) {
                    throw new JSPEmulatorException("Error evaluating attribute expression: " + e.getMessage(), e);
                }
            }
            try {
                void var10_10;
                this.valueArray[0] = var10_10;
                attrInfo.setter.invoke((Object)handler, this.valueArray);
            }
            catch (InvocationTargetException e) {
                throw new ModelContentTCFException("Exception invoking setter for attribute \"" + attribute + '\"', e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new JSPEmulatorException("Exception invoking setter for attribute \"" + attribute + '\"', e);
            }
            catch (IllegalArgumentException e) {
                throw new JSPEmulatorException("Exception invoking setter for attribute \"" + attribute + '\"', e);
            }
        }
    }

    private int processCustomTagEnd(String tagPrefix, String tagName) throws JSPEmulatorException, ModelContentTCFException {
        if (this.tagStateStack.isEmpty()) {
            throw new JSPEmulatorException("No record of tag found during custom tag end processing.");
        }
        TagState tagState = (TagState)this.tagStateStack.get(this.tagStateStack.size() - 1);
        if (this.performExtraChecking && !tagState.getTagInfo().getTagName().equals(tagName)) {
            throw new JSPEmulatorException("Out of sync.  Stack has tag \"" + tagState.getTagInfo().getTagName() + "\", but parser indicates \"" + tagName + '\"');
        }
        Tag handler = tagState.getTag();
        int endTagResponse = 6;
        if (!tagState.isExceptionDuringStartProcessing()) {
            if (!tagState.isSkippingBody() && !tagState.isBodyEmpty() && handler instanceof IterationTag) {
                int afterBodyResponse;
                Trace.trace(TRACE_MASKD, "Calling doAfterBody() for tag \"" + tagState.getTagInfo().getTagName() + "\" in " + tagState.getTagInfo().getTagClassName());
                try {
                    afterBodyResponse = ((IterationTag)handler).doAfterBody();
                }
                catch (Throwable e) {
                    throw new ModelContentTCFException("Exception from doAfterBody()", e);
                }
                if (afterBodyResponse == 2) {
                    return 1;
                }
                if (afterBodyResponse != 0) {
                    throw new JSPEmulatorException("Unknown doAfterBody() response value of " + afterBodyResponse);
                }
                if (tagState.isOutputStreamPushed()) {
                    Trace.trace(TRACE_MASKD, "Popping body content.");
                    this.pageContext.popBody();
                    tagState.setOutputStreamIsPushed(false);
                }
            }
            Trace.trace(TRACE_MASKD, "Calling doEndTag() for tag \"" + tagState.getTagInfo().getTagName() + "\" in " + tagState.getTagInfo().getTagClassName());
            try {
                endTagResponse = handler.doEndTag();
            }
            catch (Throwable e) {
                throw new ModelContentTCFException("Exception from doEndTag()", e);
            }
        }
        if (handler instanceof TryCatchFinally) {
            Trace.trace(TRACE_MASKD, "Calling doFinally() in " + tagState.getTagInfo().getTagClassName());
            try {
                ((TryCatchFinally)handler).doFinally();
            }
            catch (Throwable e) {
                tagState.setExceptionDuringFinallyProcessing(true);
                throw new ModelContentTCFException("Exception from doFinally()", e);
            }
        }
        this.popTagAndState();
        return endTagResponse == 5 ? 2 : 0;
    }

    private int processNoncustomTagStart(String tagPrefix, String tagName, Properties attributes, boolean bodyIsEmpty) throws JSPEmulatorException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.write(60);
            if (tagPrefix.length() > 0) {
                out.write(tagPrefix);
                out.write(58);
            }
            out.write(tagName);
            Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.write(32);
                out.write(key);
                out.write(61);
                if (value.indexOf("${") != -1) {
                    value = this.evaluateAttributeExpression(value);
                }
                this.quoteAttributeValue(value, out);
            }
            out.write(62);
        }
        catch (IOException e) {
            throw new JSPEmulatorException("I/O error writing template text (non-custom tag start)", e);
        }
        return 0;
    }

    private void quoteAttributeValue(String value, JspWriter out) throws IOException {
        out.write(34);
        int stringLen = value.length();
        block4: for (int i = 0; i < stringLen; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    out.write("\\\"");
                    continue block4;
                }
                case '\\': {
                    out.write("\\\\");
                    continue block4;
                }
                default: {
                    out.write((int)c);
                }
            }
        }
        out.write(34);
    }

    private int processNoncustomTagEnd(String tagPrefix, String tagName) throws JSPEmulatorException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.write("</");
            if (tagPrefix.length() > 0) {
                out.write(tagPrefix);
                out.write(58);
            }
            out.write(tagName);
            out.write(62);
        }
        catch (IOException e) {
            throw new JSPEmulatorException("I/O error writing template text (non-custom tag end)", e);
        }
        return 0;
    }

    private void popTagAndState() {
        TagState tagState = (TagState)this.tagStateStack.remove(this.tagStateStack.size() - 1);
        if (tagState.isOutputStreamPushed()) {
            Trace.trace(TRACE_MASKD, "Popping body content for tag \"" + tagState.getTagInfo().getTagName() + '\"');
            this.pageContext.popBody();
        }
        if (tagState.isHandlerReusable()) {
            this.tagPool.putHandlerInPool(tagState.getTagInfo().getTagClassName(), tagState.getAttributeNames(), tagState.getTag());
        } else {
            try {
                tagState.getTag().release();
            }
            catch (Throwable e) {
                Trace.trace(TRACE_MASKT, "Ignoring exception from Tag.release() method of " + tagState.getTag().getClass().getName() + " class.");
                Trace.trace(TRACE_MASKT, e);
            }
        }
        tagState.recycle();
        this.tagStatePool.putInPool(tagState);
    }

    private void processCatch(String tagPrefix, String tagName, ModelContentTCFException exception) throws JSPEmulatorException, ModelContentTCFException {
        TagState tagState = null;
        while (!this.tagStateStack.isEmpty() && !((tagState = (TagState)this.tagStateStack.get(this.tagStateStack.size() - 1)).getTag() instanceof TryCatchFinally)) {
            this.popTagAndState();
        }
        if (this.tagStateStack.isEmpty()) {
            throw new JSPEmulatorException("No record of <" + tagPrefix + ':' + tagName + "> tag found during catch processing.");
        }
        if (!tagState.getTagInfo().getTagName().equals(tagName)) {
            throw new JSPEmulatorException("Out of sync during catch processing.  Parser stopped on <" + tagPrefix + ':' + tagName + ">, but our stack shows \"" + tagState.getTagInfo().getTagName() + "\" tag.");
        }
        if (tagState.isExceptionDuringFinallyProcessing()) {
            this.popTagAndState();
            throw exception;
        }
        try {
            ((TryCatchFinally)this.handler).doCatch(exception.getCause());
        }
        catch (Throwable e) {
            try {
                ((TryCatchFinally)this.handler).doFinally();
                this.popTagAndState();
                if (e == exception.getCause()) {
                    throw exception;
                }
                throw new ModelContentTCFException("Propogating exception from doCatch()", e);
            }
            catch (Throwable ee) {
                this.popTagAndState();
                throw new ModelContentTCFException("Exception from doCatch()/doFinally() in processCatch()", ee);
            }
        }
        try {
            ((TryCatchFinally)this.handler).doFinally();
        }
        catch (Throwable e) {
            this.popTagAndState();
            throw new ModelContentTCFException("Exception from doFinally() in processCatch()", e);
        }
        this.popTagAndState();
    }

    private void processTemplateText(char[] ch, int start, int length) throws JSPEmulatorException {
        try {
            this.pageContext.getOut().write(ch, start, length);
        }
        catch (IOException e) {
            throw new JSPEmulatorException("I/O error writing template text", e);
        }
    }

    private void processTemplateText(String characters) throws JSPEmulatorException {
        try {
            this.pageContext.getOut().write(characters);
        }
        catch (IOException e) {
            throw new JSPEmulatorException("I/O error writing template text (from String)", e);
        }
    }

    private void processELExpression(String expression) throws JSPEmulatorException {
        Trace.trace(TRACE_MASKF, "Evaluating template text expression: " + expression);
        try {
            String result = (String)this.elEvaluator.evaluate(expression, (Object)this.pageContext, class$java$lang$String == null ? (class$java$lang$String = JSPEmulator.class$("java.lang.String")) : class$java$lang$String, null, "");
            this.pageContext.getOut().write(result);
        }
        catch (ELException e) {
            throw new JSPEmulatorException("Error evaluating template text expression \"" + expression + "\"", e);
        }
        catch (IOException e) {
            throw new JSPEmulatorException("I/O error writing EL expression result", e);
        }
    }

    private String evaluateAttributeExpression(String expression) throws JSPEmulatorException {
        Trace.trace(TRACE_MASKF, "Evaluating attribute expression in non-custom tag: " + expression);
        try {
            return (String)this.elEvaluator.evaluate(expression, (Object)this.pageContext, class$java$lang$String == null ? (class$java$lang$String = JSPEmulator.class$("java.lang.String")) : class$java$lang$String, null, "");
        }
        catch (ELException e) {
            throw new JSPEmulatorException("Error evaluating attribute expression \"" + expression + "\"", e);
        }
    }

    private void processJSPDirective(char[] ch, int start, int length) throws JSPEmulatorException {
        JSPDirective directive = this.parseDirective(ch, start, length);
        if (!directive.getName().equals("taglib")) {
            throw new JSPEmulatorException("Directive name \"" + directive.getName() + "\" is not supported by the JSP emulator");
        }
        this.processTagLibDirective(directive);
    }

    private void processTagLibDirective(JSPDirective directive) throws JSPEmulatorException {
        String uri = directive.getAttribute("uri");
        String prefix = directive.getAttribute("prefix");
        if (uri == null || prefix == null) {
            throw new JSPEmulatorException("taglib directive is missing \"uri\" or \"prefix\" attribute");
        }
        TagLibraryInfo taglib = this.getTagLibForPrefix(prefix);
        if (taglib != null) {
            throw new JSPEmulatorException("taglib library prefix \"" + prefix + "\" is already mapped.");
        }
        taglib = this.tldManager.getTagLibForURI(uri);
        if (taglib == null) {
            throw new JSPEmulatorException("Unable to resolve taglib uri \"" + uri + "\".");
        }
        this.setTagLibForPrefix(prefix, taglib);
    }

    private TagLibraryInfo getTagLibForPrefix(String prefix) {
        if (this.prefixes == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.prefixes, prefix);
        if (index < 0) {
            return null;
        }
        return this.tagLibraries[index];
    }

    private void setTagLibForPrefix(String prefix, TagLibraryInfo info) {
        if (this.prefixes == null) {
            this.prefixes = new String[1];
            this.tagLibraries = new TagLibraryInfo[1];
            this.prefixes[0] = prefix;
            this.tagLibraries[0] = info;
            return;
        }
        int index = Arrays.binarySearch(this.prefixes, prefix);
        if (index >= 0) {
            throw new IllegalArgumentException("Prefix should not already be in the list");
        }
        index = -(index + 1);
        String[] oldPrefixes = this.prefixes;
        TagLibraryInfo[] oldTaglibraries = this.tagLibraries;
        this.prefixes = new String[oldPrefixes.length + 1];
        this.tagLibraries = new TagLibraryInfo[oldTaglibraries.length + 1];
        if (index > 0) {
            System.arraycopy(oldPrefixes, 0, this.prefixes, 0, index);
            System.arraycopy(oldTaglibraries, 0, this.tagLibraries, 0, index);
        }
        this.prefixes[index] = prefix;
        this.tagLibraries[index] = info;
        if (index < oldPrefixes.length) {
            System.arraycopy(oldPrefixes, index, this.prefixes, index + 1, oldPrefixes.length - index);
            System.arraycopy(oldTaglibraries, index, this.tagLibraries, index + 1, oldPrefixes.length - index);
        }
    }

    private JSPDirective parseDirective(char[] ch, int start, int length) throws JSPEmulatorException {
        int i;
        JSPDirective directive = new JSPDirective();
        int end = start + length - 2;
        for (i = start + 3; i < end && this.isWhitespace(ch[i]); ++i) {
        }
        if (i == end) {
            throw new JSPEmulatorException("Missing directive name in JSP directive block");
        }
        start = i;
        while (i < end && !this.isWhitespace(ch[i])) {
            ++i;
        }
        String directiveName = new String(ch, start, i - start);
        directive.setName(directiveName);
        while (true) {
            if (i < end && this.isWhitespace(ch[i])) {
                ++i;
                continue;
            }
            if (i == end) break;
            start = i;
            while (i < end && ch[i] != '=') {
                ++i;
            }
            if (i == end) {
                throw new JSPEmulatorException("Missing '=' after attribute name in directive \"" + directiveName + '\"');
            }
            String key = new String(ch, start, i - start);
            if (++i == end) {
                throw new JSPEmulatorException("Missing attribute value for attribute name \"" + key + '\"');
            }
            if (ch[i] != '\"') {
                throw new JSPEmulatorException("Attribute value must be double quoted for attribute name \"" + key + '\"');
            }
            for (i = start = i + 1; i < end && ch[i] != '\"'; ++i) {
            }
            if (i == end) {
                throw new JSPEmulatorException("Missing '\"' at end of attribute value for attribute name \"" + key + '\"');
            }
            String value = new String(ch, start, i - start);
            directive.addAttribute(key, value);
            ++i;
        }
        return directive;
    }

    private boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    private TagState getTagStateFromPool() {
        TagState tagState = (TagState)this.tagStatePool.getFromPool();
        if (tagState == null) {
            tagState = new TagState();
        }
        return tagState;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JSPContentHandler
    implements ModelContentHandler {
        boolean inJSPComment;

        private JSPContentHandler() {
        }

        public void startDocument() throws PanelModelException {
            JSPEmulator.this.pageContext.getResponse().setContentType("text/html");
        }

        public int startElement(String tagPrefix, String tagName, Properties attributes, boolean bodyIsEmpty) throws PanelModelException {
            if (JSPEmulator.this.isCustomTagPrefix(tagPrefix)) {
                return JSPEmulator.this.processCustomTagStart(tagPrefix, tagName, attributes, bodyIsEmpty);
            }
            return JSPEmulator.this.processNoncustomTagStart(tagPrefix, tagName, attributes, bodyIsEmpty);
        }

        public int endElement(String tagPrefix, String tagName) throws PanelModelException {
            if (JSPEmulator.this.isCustomTagPrefix(tagPrefix)) {
                return JSPEmulator.this.processCustomTagEnd(tagPrefix, tagName);
            }
            return JSPEmulator.this.processNoncustomTagEnd(tagPrefix, tagName);
        }

        public void catchElement(String tagPrefix, String tagName, ModelContentTCFException exception) throws PanelModelException {
            JSPEmulator.this.processCatch(tagPrefix, tagName, exception);
        }

        public void endDocument() throws PanelModelException {
            this.inJSPComment = false;
        }

        public void characters(char[] ch, int start, int length) throws PanelModelException {
            Trace.trace(JSPEmulator.TRACE_MASKD, "Template text: \"" + new String(ch, start, length) + '\"');
            if (this.inJSPComment) {
                return;
            }
            JSPEmulator.this.processTemplateText(ch, start, length);
        }

        public void jspELExpression(char[] ch, int start, int length) throws PanelModelException {
            Trace.trace(JSPEmulator.TRACE_MASKD, "Template EL expression: \"" + new String(ch, start, length) + '\"');
            JSPEmulator.this.processELExpression(new String(ch, start, length));
        }

        public void jspDirective(char[] ch, int start, int length) throws PanelModelException {
            Trace.trace(JSPEmulator.TRACE_MASKD, "JSP Directive: \"" + new String(ch, start, length) + '\"');
            JSPEmulator.this.processJSPDirective(ch, start, length);
        }

        public void startIgnoredConstruct(String prefix) throws PanelModelException {
            Trace.trace(JSPEmulator.TRACE_MASKD, "Start of ignored contruct: prefix==\"" + prefix + '\"');
            if (prefix.equals("<!--") || prefix.equals("<%--")) {
                this.inJSPComment = true;
            } else {
                JSPEmulator.this.processTemplateText(prefix);
            }
        }

        public void endIgnoredConstruct(String suffix) throws PanelModelException {
            Trace.trace(JSPEmulator.TRACE_MASKD, "End of ignored contruct: suffix==\"" + suffix + '\"');
            if (this.inJSPComment) {
                this.inJSPComment = false;
            } else {
                JSPEmulator.this.processTemplateText(suffix);
            }
        }

        public void error(PanelModelException e, String location) {
            Trace.trace(JSPEmulator.TRACE_MASKT, "Received error() callback during serialize");
            Trace.trace(JSPEmulator.TRACE_MASKT, e);
        }
    }

    private static class JSPDirective {
        String name;
        Map attributes = new HashMap();

        private JSPDirective() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String getAttribute(String key) {
            return (String)this.attributes.get(key);
        }

        public Map getAttributes() {
            return this.attributes;
        }
    }

    private static class TagState {
        private TagInfoEmul tagInfo;
        private Tag handler;
        private String[] attributeNames;
        private boolean bodyIsEmpty;
        private boolean tagHandlerReusable;
        private boolean skippingBody;
        private boolean outputStreamIsPushed;
        private boolean exceptionInStartElement;
        private boolean exceptionInFinallyProcessing;

        private TagState() {
        }

        public void recycle() {
            this.tagInfo = null;
            this.handler = null;
            this.attributeNames = null;
            this.bodyIsEmpty = false;
            this.skippingBody = false;
            this.outputStreamIsPushed = false;
            this.exceptionInStartElement = false;
        }

        public TagInfoEmul getTagInfo() {
            return this.tagInfo;
        }

        public void setTagInfo(TagInfoEmul tagInfo) {
            this.tagInfo = tagInfo;
        }

        public Tag getTag() {
            return this.handler;
        }

        public void setTag(Tag handler) {
            this.handler = handler;
        }

        public String[] getAttributeNames() {
            return this.attributeNames;
        }

        public void setAttributeNames(String[] attributeNames) {
            this.attributeNames = attributeNames;
        }

        public boolean isBodyEmpty() {
            return this.bodyIsEmpty;
        }

        public void setBodyEmpty(boolean empty) {
            this.bodyIsEmpty = empty;
        }

        public boolean isHandlerReusable() {
            return this.bodyIsEmpty;
        }

        public void setHandlerReusable(boolean reusable) {
            this.tagHandlerReusable = reusable;
        }

        public boolean isSkippingBody() {
            return this.bodyIsEmpty;
        }

        public void setSkippingBody(boolean skipping) {
            this.skippingBody = skipping;
        }

        public boolean isOutputStreamPushed() {
            return this.outputStreamIsPushed;
        }

        public void setOutputStreamIsPushed(boolean isPushed) {
            this.outputStreamIsPushed = isPushed;
        }

        public boolean isExceptionDuringStartProcessing() {
            return this.exceptionInStartElement;
        }

        public void setExceptionDuringStartProcessing(boolean caughtException) {
            this.exceptionInStartElement = caughtException;
        }

        public boolean isExceptionDuringFinallyProcessing() {
            return this.exceptionInFinallyProcessing;
        }

        public void setExceptionDuringFinallyProcessing(boolean caughtException) {
            this.exceptionInFinallyProcessing = caughtException;
        }
    }
}

